#pragma once

// forward definition of CSingleton
class	CSingleton;
typedef	CSingleton*			PSingleton;
typedef	vector<PSingleton>	CSingletonVector;


class CDestructionManager {
public:
	static CDestructionManager* getInstance() {
		static	CDestructionManager	manager;

		return &manager;
	}

	void remember(PSingleton singleton);
	void destroyAll();
protected:
	CSingletonVector	singletons;
	vector<bool>		destroyed;
	bool				destroying;

	CDestructionManager();

	void destroyDependencies(PSingleton singleton);
	void destroy(int index);
};


class CSingleton {
public:
	virtual void destroy() = 0;
	virtual CSingletonVector getDependencies() = 0;
protected:
	CSingleton() {
		CDestructionManager::getInstance()->remember( this );
	}
};
